var VHDissector;
if( !VHDissector )
	VHDissector = {};

(function() {
	var isAPIAvailable = ( typeof tltAPI !== "undefined" );
	
	VHDissector.getProductName = function() {
		return isAPIAvailable ? tltAPI.createPromise( "getProductName" ) : Promise.resolve( "VH Dissector" );
	}
	
	VHDissector.getProductIdentifier = function() {
		return isAPIAvailable ? tltAPI.createPromise( "getProductIdentifier" ) : Promise.resolve( "" );
	}
	
	VHDissector.getProductVersion = function() {
		return isAPIAvailable ? tltAPI.createPromise( "getProductVersion" ) : Promise.resolve( "" );
	}
	
	VHDissector.getBodyClasses = function() {
		if( isAPIAvailable ) {
			return VHDissector.getProductIdentifier().then(function( identifier ){
				return "vh-dissector " + identifier.toLowerCase().split( '.' ).pop();
			});
		}
		else
			return Promise.resolve( "" );
	}
	
	VHDissector.getLicenseId = function() {
		return isAPIAvailable ? tltAPI.createPromise( "getLicenseId" ) : Promise.resolve( "" );
	}
})();